/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import icyllis.modernui.text.NoCopySpan;
import icyllis.modernui.text.SpanWatcher;
import icyllis.modernui.text.Spannable;
import icyllis.modernui.text.Spanned;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.lang.reflect.Array;
import javax.annotation.Nonnull;

abstract class SpannableStringInternal {
    private static final int START = 0;
    private static final int END = 1;
    private static final int FLAGS = 2;
    private static final int COLUMNS = 3;
    private final String mText;
    private Object[] mSpans;
    private int[] mSpanData;
    private int mSpanCount;

    SpannableStringInternal(CharSequence source, int start, int end, boolean ignoreNoCopySpan) {
        this.mText = start == 0 && end == source.length() ? source.toString() : source.toString().substring(start, end);
        this.mSpans = ObjectArrays.EMPTY_ARRAY;
        this.mSpanData = IntArrays.EMPTY_ARRAY;
        if (source instanceof Spanned) {
            if (source instanceof SpannableStringInternal) {
                this.copySpansFromInternal((SpannableStringInternal)((Object)source), start, end, ignoreNoCopySpan);
            } else {
                this.copySpansFromSpanned((Spanned)source, start, end, ignoreNoCopySpan);
            }
        }
    }

    private void copySpansFromSpanned(@Nonnull Spanned src, int start, int end, boolean ignoreNoCopySpan) {
        Object[] spans;
        for (Object span : spans = src.getSpans(start, end, Object.class)) {
            if (ignoreNoCopySpan && span instanceof NoCopySpan) continue;
            int st = src.getSpanStart(span);
            int en = src.getSpanEnd(span);
            int fl = src.getSpanFlags(span);
            if (st < start) {
                st = start;
            }
            if (en > end) {
                en = end;
            }
            this.setSpan(span, st - start, en - start, fl, false);
        }
    }

    private void copySpansFromInternal(@Nonnull SpannableStringInternal src, int start, int end, boolean ignoreNoCopySpan) {
        int i;
        int count = 0;
        int[] srcData = src.mSpanData;
        Object[] srcSpans = src.mSpans;
        int limit = src.mSpanCount;
        boolean hasNoCopySpan = false;
        for (i = 0; i < limit; ++i) {
            int spanStart = srcData[i * 3 + 0];
            int spanEnd = srcData[i * 3 + 1];
            if (spanStart > end || spanEnd < start || spanStart != spanEnd && start != end && (spanStart == end || spanEnd == start)) continue;
            if (srcSpans[i] instanceof NoCopySpan) {
                hasNoCopySpan = true;
                if (ignoreNoCopySpan) continue;
            }
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (!hasNoCopySpan && start == 0 && end == src.length()) {
            this.mSpans = new Object[src.mSpans.length];
            this.mSpanData = new int[src.mSpanData.length];
            this.mSpanCount = src.mSpanCount;
            System.arraycopy(src.mSpans, 0, this.mSpans, 0, src.mSpans.length);
            System.arraycopy(src.mSpanData, 0, this.mSpanData, 0, this.mSpanData.length);
        } else {
            this.mSpanCount = count;
            this.mSpans = new Object[this.mSpanCount];
            this.mSpanData = new int[this.mSpans.length * 3];
            int j = 0;
            for (i = 0; i < limit; ++i) {
                int spanStart = srcData[i * 3 + 0];
                int spanEnd = srcData[i * 3 + 1];
                if (spanStart > end || spanEnd < start || spanStart != spanEnd && start != end && (spanStart == end || spanEnd == start) || ignoreNoCopySpan && srcSpans[i] instanceof NoCopySpan) continue;
                if (spanStart < start) {
                    spanStart = start;
                }
                if (spanEnd > end) {
                    spanEnd = end;
                }
                this.mSpans[j] = srcSpans[i];
                this.mSpanData[j * 3 + 0] = spanStart - start;
                this.mSpanData[j * 3 + 1] = spanEnd - start;
                this.mSpanData[j * 3 + 2] = srcData[i * 3 + 2];
                ++j;
            }
        }
    }

    void setSpan(Object span, int start, int end, int flags) {
        this.setSpan(span, start, end, flags, true);
    }

    private boolean isIndexFollowsNextLine(int index) {
        return index != 0 && index != this.length() && this.charAt(index - 1) != '\n';
    }

    private void setSpan(Object span, int start, int end, int flags, boolean enforceParagraph) {
        Arrays.ensureFromTo((int)this.length(), (int)start, (int)end);
        if ((flags & 0x33) == 51) {
            if (this.isIndexFollowsNextLine(start)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + this.charAt(start - 1) + ")");
            }
            if (this.isIndexFollowsNextLine(end)) {
                if (!enforceParagraph) {
                    return;
                }
                throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + this.charAt(end - 1) + ")");
            }
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != span) continue;
            int ost = data[i * 3 + 0];
            int oen = data[i * 3 + 1];
            data[i * 3 + 0] = start;
            data[i * 3 + 1] = end;
            data[i * 3 + 2] = flags;
            this.sendSpanChanged(span, ost, oen, start, end);
            return;
        }
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            Object[] newSpans = new Object[this.mSpanCount + (this.mSpanCount >> 1)];
            int[] newData = new int[newSpans.length * 3];
            System.arraycopy(this.mSpans, 0, newSpans, 0, this.mSpanCount);
            System.arraycopy(this.mSpanData, 0, newData, 0, this.mSpanCount * 3);
            this.mSpans = newSpans;
            this.mSpanData = newData;
        }
        this.mSpans[this.mSpanCount] = span;
        this.mSpanData[this.mSpanCount * 3 + 0] = start;
        this.mSpanData[this.mSpanCount * 3 + 1] = end;
        this.mSpanData[this.mSpanCount * 3 + 2] = flags;
        ++this.mSpanCount;
        if (this instanceof Spannable) {
            this.sendSpanAdded(span, start, end);
        }
    }

    void removeSpan(Object span) {
        this.removeSpan(span, 0);
    }

    public void removeSpan(Object span, int flags) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != span) continue;
            int ost = data[i * 3 + 0];
            int oen = data[i * 3 + 1];
            int c = count - (i + 1);
            System.arraycopy(spans, i + 1, spans, i, c);
            System.arraycopy(data, (i + 1) * 3, data, i * 3, c * 3);
            --this.mSpanCount;
            if ((flags & 0x200) == 0) {
                this.sendSpanRemoved(span, ost, oen);
            }
            return;
        }
    }

    @Nonnull
    public <T> T[] getSpans(int start, int end, @Nonnull Class<T> type) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        int found = 0;
        Object[] temp = null;
        Object first = null;
        for (int i = 0; i < count; ++i) {
            int priority;
            int spanStart = data[i * 3 + 0];
            int spanEnd = data[i * 3 + 1];
            if (spanStart > end || spanEnd < start || spanStart != spanEnd && start != end && (spanStart == end || spanEnd == start) || type != Object.class && !type.isInstance(spans[i])) continue;
            if (found == 0) {
                first = spans[i];
                ++found;
                continue;
            }
            if (found == 1) {
                temp = (Object[])Array.newInstance(type, count - i + 1);
                temp[0] = first;
            }
            if ((priority = data[i * 3 + 2] & 0xFF0000) != 0) {
                int j;
                for (j = 0; j < found && priority <= (this.getSpanFlags(temp[j]) & 0xFF0000); ++j) {
                }
                System.arraycopy(temp, j, temp, j + 1, found - j);
                temp[j] = spans[i];
                ++found;
                continue;
            }
            temp[found++] = spans[i];
        }
        if (found == 0) {
            return type == Object.class ? ObjectArrays.EMPTY_ARRAY : Array.newInstance(type, 0);
        }
        if (found == 1) {
            temp = (Object[])Array.newInstance(type, 1);
            temp[0] = first;
            return temp;
        }
        if (found == temp.length) {
            return temp;
        }
        Object[] r = (Object[])Array.newInstance(type, found);
        System.arraycopy(temp, 0, r, 0, found);
        return r;
    }

    public int getSpanStart(Object span) {
        Object[] spans = this.mSpans;
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            if (spans[i] != span) continue;
            return this.mSpanData[i * 3 + 0];
        }
        return -1;
    }

    public int getSpanEnd(Object span) {
        Object[] spans = this.mSpans;
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            if (spans[i] != span) continue;
            return this.mSpanData[i * 3 + 1];
        }
        return -1;
    }

    public int getSpanFlags(Object span) {
        Object[] spans = this.mSpans;
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            if (spans[i] != span) continue;
            return this.mSpanData[i * 3 + 2];
        }
        return 0;
    }

    public int nextSpanTransition(int start, int limit, @Nonnull Class<?> type) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = 0; i < count; ++i) {
            int st = data[i * 3 + 0];
            int en = data[i * 3 + 1];
            if (st > start && st < limit && (type == Object.class || type.isInstance(spans[i]))) {
                limit = st;
            }
            if (en <= start || en >= limit || type != Object.class && !type.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    private void sendSpanAdded(Object span, int start, int end) {
        SpanWatcher[] watchers;
        for (SpanWatcher spanWatcher : watchers = this.getSpans(start, end, SpanWatcher.class)) {
            spanWatcher.onSpanAdded((Spannable)((Object)this), span, start, end);
        }
    }

    private void sendSpanRemoved(Object span, int start, int end) {
        SpanWatcher[] watchers;
        for (SpanWatcher spanWatcher : watchers = this.getSpans(start, end, SpanWatcher.class)) {
            spanWatcher.onSpanRemoved((Spannable)((Object)this), span, start, end);
        }
    }

    private void sendSpanChanged(Object span, int s2, int e, int st, int en) {
        SpanWatcher[] watchers;
        for (SpanWatcher spanWatcher : watchers = this.getSpans(Math.min(s2, st), Math.max(e, en), SpanWatcher.class)) {
            spanWatcher.onSpanChanged((Spannable)((Object)this), span, s2, e, st, en);
        }
    }

    @Nonnull
    public final String toString() {
        return this.mText;
    }

    public final int length() {
        return this.mText.length();
    }

    public final char charAt(int index) {
        return this.mText.charAt(index);
    }

    public final void getChars(int start, int end, char[] dest, int off) {
        this.mText.getChars(start, end, dest, off);
    }

    public boolean equals(Object o) {
        if (o instanceof Spanned && this.toString().equals(o.toString())) {
            Spanned other = (Spanned)o;
            Object[] otherSpans = other.getSpans(0, other.length(), Object.class);
            Object[] thisSpans = this.getSpans(0, this.length(), Object.class);
            if (this.mSpanCount == otherSpans.length) {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    Object thisSpan = thisSpans[i];
                    Object otherSpan = otherSpans[i];
                    if (!(thisSpan == this ? other != otherSpan || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan) : !thisSpan.equals(otherSpan) || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.toString().hashCode();
        hash = hash * 31 + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object span = this.mSpans[i];
            if (span != this) {
                hash = hash * 31 + span.hashCode();
            }
            hash = hash * 31 + this.getSpanStart(span);
            hash = hash * 31 + this.getSpanEnd(span);
            hash = hash * 31 + this.getSpanFlags(span);
        }
        return hash;
    }
}

